package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.VdocOs4Dao;
import com.ejie.ab04b.model.VdocOs4;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * VdocOs4ServiceImpl generated by UDA, 29-jun-2017 8:32:42.
 * 
 * @author UDA
 */

@Service(value = "vdocOs4Service")
public class VdocOs4ServiceImpl implements VdocOs4Service {

	@Autowired
	private VdocOs4Dao vdocOs4Dao;

	/**
	 * Inserts a single row in the VdocOs4 table.
	 * 
	 *  vdocOs4
	 *            VdocOs4
	 *  VdocOs4
	 *
	 * @param vdocOs4 the vdoc os 4
	 * @return the vdoc os 4
	 */
	@Transactional(rollbackFor = Throwable.class)
	public VdocOs4 add(VdocOs4 vdocOs4) {
		return this.vdocOs4Dao.add(vdocOs4);
	}

	/**
	 * Updates a single row in the VdocOs4 table.
	 * 
	 *  vdocOs4
	 *            VdocOs4
	 *  VdocOs4
	 *
	 * @param vdocOs4 the vdoc os 4
	 * @return the vdoc os 4
	 */
	@Transactional(rollbackFor = Throwable.class)
	public VdocOs4 update(VdocOs4 vdocOs4) {
		return this.vdocOs4Dao.update(vdocOs4);
	}

	/**
	 * Finds a single row in the VdocOs4 table.
	 * 
	 *  vdocOs4
	 *            VdocOs4
	 *  VdocOs4
	 *
	 * @param vdocOs4 the vdoc os 4
	 * @return the vdoc os 4
	 */
	public VdocOs4 find(VdocOs4 vdocOs4) {
		return (VdocOs4) this.vdocOs4Dao.find(vdocOs4);
	}

	/**
	 * Deletes a single row in the VdocOs4 table.
	 * 
	 *  vdocOs4
	 *            VdocOs4
	 *
	 * @param vdocOs4 the vdoc os 4
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(VdocOs4 vdocOs4) {
		this.vdocOs4Dao.remove(vdocOs4);
	}

	/**
	 * Finds a list of rows in the VdocOs4 table.
	 * 
	 *  vdocOs4
	 *            VdocOs4
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<VdocOs4>
	 *
	 * @param vdocOs4 the vdoc os 4
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<VdocOs4> findAll(VdocOs4 vdocOs4,
			JQGridRequestDto jqGridRequestDto) {
		return (List<VdocOs4>) this.vdocOs4Dao.findAll(vdocOs4,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the VdocOs4 table using like.
	 * 
	 *  vdocOs4
	 *            VdocOs4
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<VdocOs4>
	 *
	 * @param vdocOs4 the vdoc os 4
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<VdocOs4> findAllLike(VdocOs4 vdocOs4,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<VdocOs4>) this.vdocOs4Dao.findAllLike(vdocOs4,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the VdocOs4 table.
	 * 
	 *  filterVdocOs4
	 *            VdocOs4
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *
	 * @param filterVdocOs4 the filter vdoc os 4
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	public void removeMultiple(VdocOs4 filterVdocOs4,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.vdocOs4Dao.removeMultiple(filterVdocOs4, jqGridRequestDto,
				startsWith);
	}

	/**
	 * Filter method in the VdocOs4 table.
	 * 
	 *  filterVdocOs4
	 *            VdocOs4
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<VdocOs4>
	 *
	 * @param filterVdocOs4 the filter vdoc os 4
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<VdocOs4> filter(VdocOs4 filterVdocOs4,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<VdocOs4> listaVdocOs4 = this.vdocOs4Dao.findAllLike(filterVdocOs4,
				jqGridRequestDto, false);
		Long recordNum = this.vdocOs4Dao.findAllLikeCount(
				filterVdocOs4 != null ? filterVdocOs4 : new VdocOs4(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<VdocOs4>> reorderSelection = this.vdocOs4Dao
					.reorderSelection(filterVdocOs4, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<VdocOs4>(jqGridRequestDto, recordNum,
					listaVdocOs4, reorderSelection);
		}
		return new JQGridResponseDto<VdocOs4>(jqGridRequestDto, recordNum,
				listaVdocOs4);
	}

	/**
	 * Searches rows in the VdocOs4 table.
	 * 
	 *  filterVdocOs4
	 *            VdocOs4
	 *  searchVdocOs4
	 *            VdocOs4
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<VdocOs4>>
	 *
	 * @param filterVdocOs4 the filter vdoc os 4
	 * @param searchVdocOs4 the search vdoc os 4
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<VdocOs4>> search(VdocOs4 filterVdocOs4,
			VdocOs4 searchVdocOs4, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.vdocOs4Dao.search(filterVdocOs4, searchVdocOs4,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in VdocOs4 table.
	 * 
	 *  filterVdocOs4
	 *            VdocOs4
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterVdocOs4 the filter vdoc os 4
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(VdocOs4 filterVdocOs4,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.vdocOs4Dao.reorderSelection(filterVdocOs4,
				jqGridRequestDto, startsWith);
	}

}
